Attribute VB_Name = "modMain"
Option Explicit
' Set to 0 for Production Mode
#Const DEMO_MODE = 1

#If DEMO_MODE = 1 Then
Private Const MAX_RECORDS = 5
#End If

Private Const DOUBLE_QUOTE = """"
Private Const CHAR_SMALLER = "<"
Private Const CHAR_GREATER = ">"
Private Const CHAR_OBLIQUE_SMALLER = "</"
Private Const CHAR_OBLIQUE_GREATER = " />"

Private Const DEFAULT_INDENTATION = 2

Public Function strRS2XML(rs As ADODB.Recordset, _
                  strName As String, _
                  Optional vntIndentation As Variant) As String
   Static objField       As ADODB.Field
   Static strSpaces      As String
   Static strFieldName    As String
   Static intLevel       As Integer
   Static intIndentation As Integer

   ' The following variables cannot be made static!
   Dim rsChapter         As ADODB.Recordset
   Dim strXML           As String
   Dim strDocName        As String
   Dim lngRecCount       As Long

   ' Set the identation level to a positive value
   ' DEFAULT_INDENTATION is a constant defined
   ' in the general declaration section.
   If IsMissing(vntIndentation) Then
      intIndentation = DEFAULT_INDENTATION
   Else
      intIndentation = vntIndentation
      If intIndentation < 0 Then intIndentation = DEFAULT_INDENTATION
   End If

   ' Careful now, this function is recursive!
   If intLevel = 0 Then   ' Only on top-level call.
      strXML = "<?xml version=" _
            & DOUBLE_QUOTE & "1.0" & DOUBLE_QUOTE _
            & " ?>" & vbCr
   End If

   strSpaces = Space$(intLevel * intIndentation)

   ' Form a valid Document Name and Record Name
   ' The Document Name ends in "s"; the Record Name doesn't.
   strName = strValidXMLTag(strName)
   If Right$(strName, 1) = "s" Then
      strDocName = strName
      strName = Left$(strName, Len(strName) - 1)
   Else
      strDocName = strName & "s"
   End If

   ' Start of Document TAG
   strXML = strXML & CHAR_SMALLER & strDocName & CHAR_GREATER & vbCr

   intLevel = intLevel + 1
   strSpaces = Space$(intLevel * intIndentation)

   rs.MoveFirst
   lngRecCount = 1
#If DEMO_MODE = 1 Then
   While Not rs.EOF And lngRecCount < MAX_RECORDS
#Else
   While Not rs.EOF
#End If
      ' Start of Record tag
      strXML = strXML & strSpaces _
         & CHAR_SMALLER & strName & CHAR_GREATER & vbCr

      ' Record tag Content
      For Each objField In rs.Fields
         ' Is the Field a Recordset?
         If objField.Type = adChapter Then
            ' We actually have another Recordset,
            ' so we need to recurse
            Set rsChapter = objField.Value
            If Not rsChapter.EOF Then
               intLevel = intLevel + 1
               strXML = strXML & strRS2XML(rsChapter, _
                        strName & "." & objField.Name, _
                        intIndentation)
               intLevel = intLevel - 1
            End If
         Else
            ' We have a regular Field,
            ' so we add it to the XML string

            ' Ensure we have a correctly formed tag name
            strFieldName = strValidXMLTag(strName & "." & objField.Name)

            If IsNull(objField.Value) Then
               ' Empty Field tag
               strXML = strXML & strSpaces & Space$(intIndentation) _
                  & CHAR_SMALLER & strFieldName & CHAR_OBLIQUE_GREATER & vbCr
            Else
               ' Start of Field tag
               strXML = strXML & strSpaces & Space$(intIndentation) _
                  & CHAR_SMALLER & strFieldName & CHAR_GREATER
               ' Field tag Content
               strXML = strXML & strValidXMLContent(objField.Value)
               ' End of Field tag
               strXML = strXML & CHAR_OBLIQUE_SMALLER _
                  & strFieldName & CHAR_GREATER & vbCr
            End If
         End If
      Next objField

      ' End of Record tag
      strXML = strXML & strSpaces & CHAR_OBLIQUE_SMALLER _
               & strName & CHAR_GREATER & vbCr
      ' We may be a while, so keep UI responsive
      DoEvents

      ' We're done, with this record: fetch next
      rs.MoveNext
      lngRecCount = lngRecCount + 1
   Wend

   ' The (child) recordset has been processed,
   ' so we decrease the level.
   intLevel = intLevel - 1
   strSpaces = Space$(intLevel * intIndentation)

   ' End of Document TAG
   strXML = strXML & strSpaces & CHAR_OBLIQUE_SMALLER _
         & strDocName & CHAR_GREATER & vbCr

   ' Finally, return XML string
   strRS2XML = strXML
End Function

Private Function strValidXMLTag(strTagCandidate As String) As String
   ' This function only handles occurrences of "xml" and
   ' replaces white space with "_".
   ' The implementation of the remaining rules is left as
   ' an exercise for the reader. ;)

   ' Get rid of occurrences of 'xml'
   strTagCandidate = Replace(strTagCandidate, "xml", "x_m_l")
   ' Get rid of spaces
   strValidXMLTag = Replace(strTagCandidate, " ", "_")
End Function

Private Function strValidXMLContent(strContenCandidate As String) As String
   ' Get rid of occurrences of '<'
   strContenCandidate = Replace(strContenCandidate, "<", "&lt;")
   ' Get rid of occurrences of '>'
   strContenCandidate = Replace(strContenCandidate, ">", "&gt;")
   ' Get rid of occurrences of '&'
   strContenCandidate = Replace(strContenCandidate, "&", "&amp;")
   ' Get rid of occurrences of '"'
   strContenCandidate = Replace(strContenCandidate, """", "&quot;")
   ' Get rid of occurrences of "'"
   strValidXMLContent = Replace(strContenCandidate, "'", "&apos;")
End Function

Public Sub Main()
   Dim strPath          As String

   ' Normalize Path
   strPath = App.Path
   If Right$(strPath, 1) <> "/" Then
      strPath = strPath & "/"
   End If

   CreateAuthorsXML strPath & "Authors.xml"
End Sub

Public Sub CreateAuthorsXML(strXMLFile As String)
   Dim intFileNumber   As Integer
   Dim rsAuthors      As ADODB.Recordset

   Set rsAuthors = New ADODB.Recordset

   ' Open recordset with a few columns
   ' Limit to just a few records with WHERE clause
   rsAuthors.Source = "SELECT au_id, au_fname, au_lname " _
                    & "FROM Authors WHERE au_id < 5"

   ' In the following, you need to change "srvr" to the
   ' name of your SQL Server
   rsAuthors.ActiveConnection = "Provider=sqloledb;" & _
      "Data Source=srvr;Initial Catalog=pubs;User Id=sa;Password=; "

   ' All set to open recordset...
   rsAuthors.Open   ' Open recordset (limit to just a few records with WHERE clause)

   ' Get unused file number
   intFileNumber = FreeFile
   ' Create file name
   Open strXMLFile For Output As #intFileNumber
   ' Output text
   Print #intFileNumber, strRS2XML(rsAuthors, "Author")
   ' Close file
   Close #intFileNumber

   ' Clean Up
   rsAuthors.Close
   Set rsAuthors = Nothing
End Sub
